/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.dynamo;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.dynamo.CompressionFuel;
import cofh.thermal.expansion.client.gui.dynamo.DynamoCompressionScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalFuelCategory;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CompressionFuelCategory
extends ThermalFuelCategory<CompressionFuel> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public CompressionFuelCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(DynamoCompressionScreen.TEXTURE, 26, 11, 70, 62).addPadding(0, 0, 16, 78).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.DYNAMO_COMPRESSION_BLOCK.m_7705_());
        this.durationBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.duration = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends CompressionFuel> getRecipeClass() {
        return CompressionFuel.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompressionFuel fuel, IFocusGroup focuses) {
        List inputs = fuel.getInputFluids();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 34, 11).addIngredients(VanillaTypes.FLUID, List.of(((FluidIngredient)inputs.get(0)).getFluids()))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(CompressionFuel recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalFuel)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.tankBackground.draw(matrixStack, 33, 10);
    }
}

